﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Wiekowanie towarów w  magazynach</title>
</head>
<script runat="server"> 
    
    public enum OkresMagazynowania {
        [Caption("0-7")]
        [Soneta.Tools.Priority(10)]
        d7     = 0,
        [Caption("8-15")]
        [Soneta.Tools.Priority(20)]
        d15    = 1,
        [Caption("16-30")]
        [Soneta.Tools.Priority(30)]
        d30    = 2,
        [Caption(">30")]
        [Soneta.Tools.Priority(40)]
        pd30   = 3,
        [Caption("Wszystkie")]
        [Soneta.Tools.Priority(50)]
        all     = 4,
    }

    public class ParametryBase : SerializableContextBase {
        public ParametryBase(Context cx) : base(cx) {
        }

        OkresMagazynowania okresMagazynowania = OkresMagazynowania.d7;

        public OkresMagazynowania OkresMagazynowania {
            get { return okresMagazynowania; }
            set { okresMagazynowania = value; OnChanged(EventArgs.Empty);}
        }

    WgDaty _wgDaty = WgDaty.Partii;

    public WgDaty WgDaty {
      get { return _wgDaty; }
      set { _wgDaty = value; }
    }
  }

  public enum WgDaty
  {
    [Caption("przyjęcia do bieżącego magazynu")]
    Partii,
    [Caption("pierwotnego przyjęcia")]
    PartiiPierwotnej
  }
    
    static ParametryBase parametry;
    
    [Context]
    public static ParametryBase Parametry {
        get { return parametry; }
        set { parametry = value; }
    }
    
    Date current;
    Magazyn magazynJeden;
    Magazyn[] magazyny;
    ObrotyParams pars = null;
    
    void dc_ContextLoad(Object sender, EventArgs args) {
        pars = (Soneta.Magazyny.ObrotyParams)dc[typeof(Soneta.Magazyny.ObrotyParams)];
        checkObrotyPars(pars);
        magazyny = pars.Magazyny;

        if (magazyny != null && magazyny.Length == 1)
            magazynJeden = magazyny[0];

        current = pars.Okres.Okres.To;
        if (current==Date.MaxValue)
            current = Date.Today;

        var desc = String.Format("W zestawieniu uwzględniono tylko towary, które mają zasoby mieszczące się w przedziale wiekowania: {0} dni.", CaptionAttribute.EnumToString(Parametry.OkresMagazynowania));
        if (Parametry.OkresMagazynowania == OkresMagazynowania.all)
            desc = "W zestawieniu uwzlędniono wszystkie towary o niezerowym stanie magazynowym.";

        ReportHeader.Title += String.Format("Magazyn: <STRONG>{0}|</STRONG>Stan na dzień: <STRONG>{1}</STRONG>||{2}|Wg daty: {3}",
          WydrukiTools.WydrukiStanyMagazynoweLista.FormatMagazyny(magazyny), current, desc, CaptionAttribute.EnumToString( Parametry.WgDaty ));

        if (pars.DataStanu != pars.Okres.Okres.To && pars.DataStanu != Date.Empty)
            throw new InvalidOperationException("Wiekowanie towarów może być robione tylko według stanu aktualnego oraz na koniec okresu magazynowego.");
        
        Row[] towary = (Row[])dc[typeof(Row[])];
        ArrayList arrTotal = new ArrayList();
        foreach (Towar t in towary) {
            if (TestTowar(t, current))
                arrTotal.Add(t);
        }
        Grid.DataSource = arrTotal;
    }

    private void checkObrotyPars(ObrotyParams pars) {
        if (pars == null)
            throw new ArgumentNullException("ObrotyParams pars");
        if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
            throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
    }

    private bool UwzglednijZasob(Zasob z) {
        if (z.Partia.Typ == TypPartii.Magazynowy && z.Kierunek == KierunekPartii.Przychód)
        {
            return magazynJeden != null // bo subtable zbudowany na kluczu z magazynem
                || (magazynJeden == null && Array.Exists<Magazyn>(magazyny, mag => mag == z.Magazyn)); // subtable zbudowany tylko na towarze i okresie, odrzucam zasoby z nie wybranych magazynów ... 
        }
        return false;
    }
    
    bool TestTowar(Towar t, Date current) {
        
        SubTable zasoby = magazynJeden != null ? t.Module.Magazyny.Zasoby.WgTowar[t, pars.Okres, magazynJeden] : t.Module.Magazyny.Zasoby.WgTowar[t, pars.Okres];            
        
        foreach (Zasob z in zasoby) {
            if (UwzglednijZasob(z)) {
          int dni = Compare( Parametry.WgDaty, current, z );
                if (dni <= 7 && Parametry.OkresMagazynowania == OkresMagazynowania.d7) {
                    return true;
                }
                else if (dni > 7 && dni <= 15 && Parametry.OkresMagazynowania == OkresMagazynowania.d15) {
                    return true;
                }
                else if(dni > 15 && dni <= 30 && Parametry.OkresMagazynowania == OkresMagazynowania.d30) {
                    return true;
                }
                else if (dni > 30 && Parametry.OkresMagazynowania == OkresMagazynowania.pd30) {
                    return true;
                }
                else if (Parametry.OkresMagazynowania == OkresMagazynowania.all) {
                    return true;
                }
            }
        }
        
        return false;
    }

    int Compare( WgDaty wgDaty, Date x, Zasob y )
    {
      switch (wgDaty)
      {
        case WgDaty.PartiiPierwotnej:
        {
          return Math.Max( x - y.PartiaPierwotna.Data, 0 );
        }
        default:
        {
          return Math.Max( x - y.Partia.Data, 0 );
        }
      }
    }

    void Grid_BeforeRow(Object sender, RowEventArgs args) {

        Towar t = (Towar)args.Row;

        decimal v0 = Soneta.Tools.Math.BlankDecimal, v1 = Soneta.Tools.Math.BlankDecimal, 
            v2 = Soneta.Tools.Math.BlankDecimal, v3 = Soneta.Tools.Math.BlankDecimal;
        Quantity q0 = Quantity.Empty, q1 = Quantity.Empty, 
            q2 = Quantity.Empty, q3 = Quantity.Empty;

        SubTable zasoby = magazynJeden != null ? t.Module.Magazyny.Zasoby.WgTowar[t, pars.Okres, magazynJeden] : t.Module.Magazyny.Zasoby.WgTowar[t, pars.Okres];
        
        foreach (Zasob z in zasoby) {
            if (UwzglednijZasob(z)) {
                int dni = Compare( Parametry.WgDaty, current, z );
                if (dni<=7) {
                    q0 += z.Ilosc; v0 += z.Partia.Wartosc;
                }
                else if (dni<=15) {
                    q1 += z.Ilosc; v1 += z.Partia.Wartosc;
                }
                else if (dni<=30) {
                    q2 += z.Ilosc; v2 += z.Partia.Wartosc;
                }
                else if (dni>30) {
                    q3 += z.Ilosc; v3 += z.Partia.Wartosc;
                }
            }  
        }

        colIlosc0.EditValue = q0;
        colIlosc1.EditValue = q1;
        colIlosc2.EditValue = q2;
        colIlosc3.EditValue = q3;
        colWartosc0.EditValue = v0;
        colWartosc1.EditValue = v1;
        colWartosc2.EditValue = v2;
        colWartosc3.EditValue = v3;
    }

</script>
<body>
    <form method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad" Landscape="true"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Wiekowanie towarów|</STRONG>" runat="server"></eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel"
            ShowGroupSum="True" OnBeforeRow="Grid_BeforeRow">
            <Columns>
                <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="#" Width="4" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" DataMember="Kod" Width="14" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" DataMember="Nazwa" Total="Info" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="colIlosc0" runat="server" Align="Right" Caption="0-7 dni~Ilość" Width="10" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="colWartosc0" runat="server" Align="Right" Caption="0-7 dni~Eartość" Format="{0:n}" Width="15" Total="Sum" EncodeHTML="True">
                </ea:GridColumn>
                 <ea:GridColumn ID="colIlosc1" runat="server" Align="Right" Caption="8-15 dni~Ilość" Width="10" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="colWartosc1" runat="server" Align="Right" Caption="8-15 dni~Wartość" Format="{0:n}" Width="15" Total="Sum" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="colIlosc2" runat="server" Align="Right" Caption="16-30 dni~Ilość" Width="10" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="colWartosc2" runat="server" Align="Right" Caption="16-30 dni~Wartość" Format="{0:n}" Width="15" Total="Sum" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="colIlosc3" runat="server" Align="Right" Caption="powyżej 30 dni~Ilość" Width="10" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="colWartosc3" runat="server" Align="Right" Caption="powyżej 30 dni~Wartość" Format="{0:n}" Width="15" Total="Sum" EncodeHTML="True">
                </ea:GridColumn>
           </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" />
    </form>
</body>
</html>
